<?php

namespace Spatie\Image\Test\Manipulations;

use Spatie\Image\Exceptions\InvalidManipulation;
use Spatie\Image\Image;

it('can sharpen', function () {
    $targetFile = $this->tempDir->path('conversion.jpg');

    Image::load(getTestJpg())->sharpen(50)->save($targetFile);

    expect($targetFile)->toBeFile();
});

it('will throw an exception when passing an invalid sharpen value', function () {
    Image::load(getTestJpg())->sharpen(101);
})->throws(InvalidManipulation::class);
