<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Shipment extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'order_id',
        'shipment_number',
        'carrier',
        'tracking_number',
        'tracking_url',
        'status',
        'shipping_method_id',
        'shipping_cost',
        'packages',
        'weight',
        'weight_unit',
        'dimensions',
        'dimensions_unit',
        'shipped_date',
        'estimated_delivery_date',
        'delivery_date',
        'notes',
        'created_by'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'shipping_cost' => 'decimal:2',
        'packages' => 'integer',
        'weight' => 'decimal:2',
        'shipped_date' => 'datetime',
        'estimated_delivery_date' => 'datetime',
        'delivery_date' => 'datetime',
    ];

    /**
     * Get the order that owns the shipment.
     */
    public function order()
    {
        return $this->belongsTo(Order::class);
    }

    /**
     * Get the items for the shipment.
     */
    public function items()
    {
        return $this->hasMany(ShipmentItem::class);
    }

    /**
     * Get the tracking history for the shipment.
     */
    public function tracking()
    {
        return $this->hasMany(ShipmentTracking::class);
    }

    /**
     * Get the delivery attempts for the shipment.
     */
    public function deliveryAttempts()
    {
        return $this->hasMany(DeliveryAttempt::class);
    }

    /**
     * Get the user who created the shipment.
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}