<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductVariantStock extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'product_id',
        'variant_attributes',
        'quantity',
        'stock_status',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'variant_attributes' => 'json',
        'quantity' => 'integer',
    ];

    /**
     * Get the product that owns the variant stock.
     */
    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    /**
     * Scope a query to only include in-stock variants.
     */
    public function scopeInStock($query)
    {
        return $query->where('stock_status', 'in_stock');
    }

    /**
     * Scope a query to only include low-stock variants.
     */
    public function scopeLowStock($query)
    {
        return $query->where('stock_status', 'low_stock');
    }

    /**
     * Scope a query to only include out-of-stock variants.
     */
    public function scopeOutOfStock($query)
    {
        return $query->where('stock_status', 'out_of_stock');
    }
}