<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FulfillmentItem extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'fulfillment_order_id',
        'order_item_id',
        'warehouse_inventory_id',
        'quantity_requested',
        'quantity_fulfilled',
        'status',
        'notes'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'quantity_requested' => 'integer',
        'quantity_fulfilled' => 'integer',
    ];

    /**
     * Get the fulfillment order that owns the item.
     */
    public function fulfillmentOrder()
    {
        return $this->belongsTo(FulfillmentOrder::class);
    }

    /**
     * Get the order item for this fulfillment item.
     */
    public function orderItem()
    {
        return $this->belongsTo(OrderItem::class);
    }

    /**
     * Get the warehouse inventory for this fulfillment item.
     */
    public function warehouseInventory()
    {
        return $this->belongsTo(WarehouseInventory::class);
    }
}