<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Warehouse extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'code',
        'address',
        'city',
        'state',
        'postal_code',
        'country',
        'phone',
        'email',
        'is_active',
        'notes'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'is_active' => 'boolean',
    ];

    /**
     * Get the inventory items for this warehouse.
     */
    public function inventory()
    {
        return $this->hasMany(WarehouseInventory::class);
    }

    /**
     * Get the fulfillment orders for this warehouse.
     */
    public function fulfillmentOrders()
    {
        return $this->hasMany(FulfillmentOrder::class);
    }
}