<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ManualInvoice extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'manual_invoices';

    protected $fillable = [
        'order_id',
        'created_by',
        'created_user_id',
        'invoice_number',
        'invoice_date',
        'due_date',
        'current_status',
        'currency',
    ];

    protected $casts = [
        'invoice_date' => 'date',
        'due_date' => 'date',
    ];

    public function order()
    {
        return $this->belongsTo(Order::class);
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function createdUser()
    {
        return $this->belongsTo(User::class, 'created_user_id');
    }

    public function issue()
    {
        $this->update([
            'current_status' => 'issued',
        ]);
    }

    public function markAsPaid()
    {
        $this->update([
            'current_status' => 'paid',
        ]);
    }

    public function cancel()
    {
        $this->update([
            'current_status' => 'cancelled',
        ]);
    }

    public function generateInvoiceNumber(): string
    {
        $prefix = 'MINV';
        $year = date('Y');
        $month = date('m');

        $last = self::where('invoice_number', 'like', "$prefix$year$month%")
            ->orderBy('invoice_number', 'desc')
            ->first();

        if ($last) {
            $lastNumber = (int) substr($last->invoice_number, -4);
            $newNumber = str_pad($lastNumber + 1, 4, '0', STR_PAD_LEFT);
        } else {
            $newNumber = '0001';
        }

        return "$prefix$year$month$newNumber";
    }
}


