<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CustomerMembership extends Model
{
    use HasFactory;

    protected $table = 'customer_memberships';

    protected $fillable = [
        'name',
        'normal_discount',
        'extra_discount',
    ];

    /**
     * Get all customer profiles with this membership.
     */
    public function customerProfiles()
    {
        return $this->hasMany(CustomerProfile::class, 'membership_id');
    }
} 