<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\StripeService;

class StripePaymentController extends Controller
{
    protected $stripeService;

    public function __construct(StripeService $stripeService)
    {
        $this->stripeService = $stripeService;
    }

    public function showPaymentForm()
    {
        return view('payment.form');
    }

    public function processPayment(Request $request)
    {
        $request->validate([
            'amount' => 'required|numeric|min:1',
            'currency' => 'required|string|size:3',
        ]);

        $result = $this->stripeService->createPaymentIntent(
            $request->amount,
            $request->currency
        );

        if (!$result['success']) {
            return back()->with('error', 'Failed to create payment intent: ' . $result['error']);
        }

        return view('payment.process', [
            'clientSecret' => $result['client_secret'],
            'amount' => $request->amount,
            'currency' => $request->currency
        ]);
    }
} 