<?php

namespace App\Http\Controllers;

use App\Models\Section;
use Illuminate\Http\Request;

class SectionController extends Controller
{
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255|unique:sections,name',
            'status' => 'sometimes|in:0,1',
        ]);

        $section = Section::create([
            'name' => $validated['name'],
            'status' => $request->input('status', 1),
        ]);

        return response()->json(['message' => 'Section created successfully', 'section' => $section], 201);
    }

    public function index()
    {
        $sections = Section::where('status', 1)->get();
        return response()->json(['sections' => $sections], 200);
    }
}